///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	Contains message-related code.
 *	\file		IceMsg.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __ICEMSG_H__
#define __ICEMSG_H__

	//! Message types
	enum MsgType
	{
		MSG_ERROR			= 1,			//!< Error message
		MSG_SYSTEM			= 2,			//!< Kernel message
		MSG_USER			= 3,			//!< User-defined message
		MSG_FORCE_DWORD		= 0x7fffffff
	};

	// Message structure
	class ICECORE_API IceMsg
	{
		public:
		// Constructor/Destructor
									IceMsg();
									~IceMsg();

		__forceinline	bool		SetCustomText(const char* txt)	{	return mText.Set(txt);	}

						MsgType		mType;			//!< Message type
						String		mID;			//!< Message identifier
						udword		mParam;			//!< Misc parameter
						String		mText;			//!< Custom text
	};

	// Global messages
	ICECORE_API	bool			SetMsg(const IceMsg& msg);
	ICECORE_API	bool			GetMsg(IceMsg& msg);
	ICECORE_API	udword			FlushMsgs(CustomArray* log=null);
	ICECORE_API	const String*	TranslateMsg(const IceMsg& msg);

#endif // __ICEMSG_H__
